<?php 
/*
	Plugin Name: SendMails.io for WooCommerce
	Author: SendMails.io
	Author URI: http://www.sendmails.io
	Description: Connect WooCommerce with SendMails.io and send automated emails.
	Version: 0.1
	Text Domain: sendmails-addon
*/
require_once("includes/autoloads.php");

$sendMailsObj = new WoocommerceSendMailsClass;

add_action('admin_notices', [$sendMailsObj, 'pluginActiveStatusMessages']);

add_filter('woocommerce_settings_tabs_array', [$sendMailsObj, 'sendMailsAddWoocommerceSettingsTabFunc'], 50);
add_action('woocommerce_sections_sendmails', [$sendMailsObj, 'sendMailsAddSectionsFunc']);
add_action('woocommerce_settings_sendmails', [$sendMailsObj, 'sendMailsAddTabSectionContentFunc']);
add_action('woocommerce_settings_save_sendmails', [$sendMailsObj, 'sendMailsSaveTabSectionContentFunc']);
add_filter('woocommerce_get_settings_sendmails', [$sendMailsObj, 'sendMailsAddTabContentFunc'], 10, 2);

add_action('woocommerce_new_order', [$sendMailsObj, 'sendMailsWoocommerceOrderPlacementFunc'], 10, 99);
add_action('woocommerce_resume_order', [$sendMailsObj, 'sendMailsWoocommerceOrderPlacementFunc'], 10, 99);

add_action('woocommerce_order_status_failed', [$sendMailsObj, 'sendMailsWoocommerceOrderStatusFailedFunc'], 10, 1);
add_action('woocommerce_order_status_refunded', [$sendMailsObj, 'sendMailsWoocommerceOrderStatusRefundedFunc'], 10, 1);
add_action('woocommerce_order_status_completed', [$sendMailsObj, 'sendMailsWoocommerceOrderStatusCompletedFunc'], 10, 1);

add_action('woocommerce_created_customer', [$sendMailsObj, 'sendMailsWoocommerceCustomerCreatedFunc'], 10, 3);

add_action("wp_head", function(){
/* 	$sendMailsObj = new WoocommerceSendMailsClass;
	
	$orderID = 595;
		$apiHeaders[] = 'Accept: application/json';
		$apiHeaders[] = 'Content-Type: application/x-www-form-urlencoded';

		$apiURL = 'https://app.sendmails.io/api/v1/';
		
	$hookSettings = $sendMailsObj->getSendMailsWoocommerceHooksSettingsFunc('woocommerce_new_order');	
	$postFields = $sendMailsObj->getSendMailsFormatedPostFields($hookSettings, $orderID);
	
		echo "<pre>";
		print_r($postFields);
		exit;	 */
	
});